import * as Log from '../modules/log.js';
import { VersionHelper } from './version_helper.js';
import { Icon } from './resource_helpers.js';

export class LabelHelper {
    _gfxLabels = [
        'hybrid',
        'integrated',
        'vfio',
        'egpu',
        'asusmuxdiscreet',
        'none',
    ];
    _gfxLabelsMenu = [
        'Hybrid',
        'Integrated',
        'VFIO',
        'eGPU',
        'MUX / dGPU',
        'None',
    ];
    _powerLabel = [
        'active',
        'suspended',
        'off',
        'disabled',
        'active',
        'unknown',
    ];
    _powerLabelFilename = [
        'active',
        'suspended',
        'off',
        'off',
        'active',
        'gpu-integrated-active',
    ];
    _userActions = [
        0,
        1,
        2,
        3,
        4,
    ];
    vHelper;

    constructor(vInstatce) {
        Log.raw('initializing...');
        if (vInstatce instanceof VersionHelper)
            this.vHelper = vInstatce;
        else
            this.vHelper = new VersionHelper(vInstatce);
    }

    get gsVersion() {
        return this.vHelper.gsVersion();
    }

    gfxLabels(type) {
        if (!(type === 0 || type === 1) ||
            !this.vHelper.isBetween(this.vHelper.currentVersion, this.vHelper.sgfxVersionRange)) {
            return [];
        }

        switch (type) {
            case 0:
                return this._gfxLabels
                    .slice(0, 2)
                    .concat(this.v50 ? [] : this.v51 || this.v52 ? ['nvidianomodeset'] : [], this._gfxLabels.slice(-4));
            case 1:
                return this._gfxLabelsMenu
                    .slice(0, 2)
                    .concat(this.v50 ? [] : this.v51 || this.v52 ? ['Nvidia (no modeset)'] : [], this._gfxLabelsMenu.slice(-4));
            default:
                return [];
        }
    }

    get userActions() {
        return this._userActions
            .slice(0, 1)
            .concat(this.v50 ? [] : this.v51 || this.v52 ? [1] : [], this._userActions.slice(-3));
    }

    get(type, idx) {

        switch (type) {
            case 0:
            case 1:
                return this.gfxLabels(type)[idx];
            case 2:
                return this._powerLabel[idx];
            case 3:
                return this._powerLabelFilename[idx];
            default:
                return '';
        }
    }

    getAction(idx) {
        return this.userActions[idx] ?? undefined;
    }

    getIcon(iconType, type, lastState, powerType = undefined, lastPowerState = undefined) {
        let label = this.get(type, lastState);

        switch (iconType) {
            case 0:
                label = 'gpu-' + label;
                break;
            case 1:
                label = 'dgpu-' + label;
                break;
        }
        if (powerType !== undefined && lastPowerState !== undefined) {
            let powerLabel = this.get(powerType, lastPowerState);
            if (powerLabel === 'active')
                label += '-active';
        }
        return Icon.getByName(label + '-symbolic');
    }

    getGpuIcon(type, lastState, powerType = undefined, lastPowerState = undefined) {
        return this.getIcon(0, type, lastState, powerType, lastPowerState);
    }

    getDGpuIcon(type, lastState, powerType = undefined, lastPowerState = undefined) {
        return this.getIcon(1, type, lastState, powerType, lastPowerState);
    }

    is(type, idx, comp) {
        if (4)
            this.getAction(idx) === comp;
        return this.get(type, idx) === comp;
    }

    isVersion(major = 5, minor = 0) {
        return this.vHelper.isBetween(this.vHelper.currentVersion, [
            [major, minor, 0],
            [major, minor, 9999],
        ]);
    }

    get v50() {
        return this.isVersion(5, 0);
    }

    get v51() {
        return this.isVersion(5, 1);
    }

    get v52() {
        return this.isVersion(5, 2);
    }
}
